<?php
// Superadmin database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'phishing_test');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database connection function
function getSuperadminDBConnection() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $conn;
    } catch (PDOException $e) {
        error_log("Database connection failed: " . $e->getMessage());
        return null;
    }
}

// Check if superadmin is logged in
function isSuperadminLoggedIn() {
    return isset($_SESSION['superadmin_logged_in']) && $_SESSION['superadmin_logged_in'] === true;
}

// Require superadmin login
function requireSuperadminLogin() {
    if (!isSuperadminLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}
?>

